// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

#include "wxsvg.h"
#include <math.h>

#define wxSVG_DEBUG FALSE
// or TRUE to see the calls being executed
#define newline wxString("\n")
#define space " " 
#define semicolon ";"
#define     wx_round(a)    (int)((a)+.5)

wxString wxColStr ( wxColour c )
{
    unsigned char r, g, b ;
    r = c.Red ();
    g = c.Green ();
    b = c. Blue ();

    wxString s = wxDecToHex(r) + wxDecToHex(g) + wxDecToHex(b) ;
    return s ;
}


wxString wxBrushString ( wxColour c, int style )
{
wxString s = "fill:#" + wxColStr (c)  + semicolon + space ; 
        switch ( style )
    	{
    		case wxSOLID :
    			s = s + "fill-opacity:1.0; ";
    			break ;
    		case wxTRANSPARENT:
    			s = s + "fill-opacity:0.0; ";
    			break ;

    	default :
    	wxASSERT_MSG(FALSE, "wxSVGFileDC::Requested Brush Style not available") ;
//    	s2 = "<!--- wxSVGFileDC::Requested Brush Style not available in DoDrawEllipse --> \n" ;
        
    	}	
    	return s ;
}

void wxSVGFileDC::Init (wxString f, int Width, int Height, float dpi)

{
    //set up things first  wxDCBase does all this?
    m_clipping = FALSE;
    m_ok = TRUE;

//    ResetBoundingBox();

    m_signX = m_signY = 1;

    m_logicalOriginX = m_logicalOriginY =
        m_deviceOriginX = m_deviceOriginY = 0;

    m_logicalScaleX = m_logicalScaleY =
        m_userScaleX = m_userScaleY =
        m_scaleX = m_scaleY = 1.0;

    m_logicalFunction = wxCOPY;

    m_backgroundMode = wxTRANSPARENT;

    m_mappingMode = wxMM_TEXT;

    m_backgroundBrush = *wxTRANSPARENT_BRUSH;

    m_textForegroundColour = *wxBLACK;
    m_textBackgroundColour = *wxWHITE;

    m_colour = wxColourDisplay();

    m_pen  = m_prevpen = m_oldpen = *wxBLACK_PEN;
    m_font = m_prevfont = m_oldfont = *wxNORMAL_FONT;
    m_brush = m_prevbrush = m_oldbrush = *wxWHITE_BRUSH;

    ////////////////////code here

    isOK = true ;
    outfile = new wxFileOutputStream(f) ;
    isOK = outfile->IsOk ();
    if (isOK)
    {
        wxString s ;
        s = "<?xml version=\"1.0\" standalone=\"no\"?>" + newline ;
        outfile->Write (s.c_str(), s.Len() ) ;
        s = "<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 20000802//EN\" " + newline ;
        outfile->Write (s.c_str(), s.Len() ) ;
        s = "\"http://www.w3.org/TR/2000/CR-SVG-20000802/DTD/svg-20000802.dtd\"> "+ newline ;
        outfile->Write (s.c_str(), s.Len() ) ;
        s.Printf ( "<svg width=\"%.2gcm\" height=\"%.2gcm\" viewBox=\"0 0 %d %d \"> \n", float(Width)/dpi*2.54, float(Height)/dpi*2.54, Width, Height );
        // assume a 72 dpi screen; possible error with rounding here
        outfile->Write (s.c_str(), s.Len() ) ;
        s = "<title> " + f + " </title>" + newline ;
        outfile->Write (s.c_str(), s.Len() ) ;
        s = wxString ("<desc>Picture generated by wxSVG ") + wxSVGVersion + " </desc>"+ newline ;
        outfile->Write (s.c_str(), s.Len() ) ;
        s =  "<g style=\"fill:black; stroke:black; stroke-width:1\">" + newline ;
        outfile->Write (s.c_str(), s.Len() ) ;

    }
    isOK = outfile->IsOk ();
}


// constructors
wxSVGFileDC::wxSVGFileDC (wxString f)
{                                                 // quarter 640x480 screen display at 72 dpi
    Init (f,320,240,72.0);
};
wxSVGFileDC::wxSVGFileDC (wxString f, int Width, int Height)
{
    Init (f,Width,Height,72.0);
};
wxSVGFileDC::wxSVGFileDC (wxString f, int Width, int Height, float dpi)
{
    Init (f,Width,Height,dpi);
};



void wxSVGFileDC::DoDrawLine (wxCoord x1, wxCoord y1, wxCoord x2, wxCoord y2)
{

    wxString s ;
    s.Printf ( "<path d=\"M%d %d L%d %d\" /> \n", x1,y1,x2,y2 );
    if (isOK)
    {
        outfile->Write (s.c_str(), s.Len() ) ;
    }
    isOK = outfile->IsOk ();
    wxASSERT_MSG(!wxSVG_DEBUG, "wxSVGFileDC::DrawLine Call executed") ;
    CalcBoundingBox(x1, y1) ;
    CalcBoundingBox(x2, y2) ;
    return;
};

void wxSVGFileDC::DoDrawPoint (wxCoord x1, wxCoord y1)
{
wxString s;
s = "<g style = \"stroke-linecap:round;\" > " + newline ;
outfile->Write (s.c_str(), s.Len() ) ;
DrawLine ( x1,y1,x1,y1 );
s = "</g>";
outfile->Write (s.c_str(), s.Len() ) ;
isOK = outfile->IsOk ();
}


void wxSVGFileDC::DoDrawCheckMark(wxCoord x1, wxCoord y1,
                           wxCoord width, wxCoord height)
{
    wxCoord x2 = x1 + width,
            y2 = y1 + height;



    // this is to yield width of 3 for width == height == 10

    SetPen(wxPen(GetTextForeground(), (width + height + 1) / 7, wxSOLID));



    // we're drawing a scaled version of wx/generic/tick.xpm here

    wxCoord x3 = x1 + (4*width) / 10,   // x of the tick bottom

            y3 = y1 + height / 2;       // y of the left tick branch

    DoDrawLine(x1, y3, x3, y2);

    DoDrawLine(x3, y2, x2, y1);



    CalcBoundingBox(x1, y1);

    CalcBoundingBox(x2, y2);
SetPen ( wxNullPen );
}

void wxSVGFileDC::DoDrawText(const wxString& text, wxCoord x1, wxCoord y1)
{
    wxString s1, s2, s3, s4, sf ;
    wxString s = text ;                           // as text is used in <>

    // calculate box
    int th, tw ;
    wxCoord desc ;
    DoGetTextExtent ( text, &tw, &th, &desc );
    CalcBoundingBox(x1, y1) ;
    CalcBoundingBox(x1 + tw, y1 + th) ;

    // draw background first
    // just like DoDrwRectangle except we pass the text color to it and set the border to a 1 pixel wide text background
    
    wxASSERT_MSG(!wxSVG_DEBUG, "wxSVGFileDC::DrawText Call plotting text background") ;

    if (m_backgroundMode == wxSOLID)
    {
        s1.Printf ( " <rect x=\"%d\" y=\"%d\" width=\"%d\" height=\"%d\"  ", x1,y1+desc-th, tw, th);
        s1 = s1 + "style=\"fill:#" + wxColStr (m_textBackgroundColour) + "; " ;
        s1 = s1 + "stroke-width:1; stroke:#" + wxColStr (m_textBackgroundColour) + "; " ;
        s1 = s1 + " \" /> " ;
        s1 = s1 + newline ;
        outfile->Write (s1.c_str(), s1.Len() ) ;
    }

    // now draw text

    int ch = GetCharHeight ();

    s1.Printf (" <text x=\"%d\" y=\"%d\" ",x1,y1 + ch );

    sf = m_font.GetFaceName () ;
    if (sf.Len () > 0) s2 = "style=\"font-family:" + sf + "; " ;
    else s2 = "style=\" " ;
    s3.Printf ("font-size:%dpt; fill:#", m_font.GetPointSize () );
    s3 = s3  + wxColStr (m_textForegroundColour) + "; stroke:#" + wxColStr (m_textForegroundColour) + "; " ;
    s4 = "stroke-width:0;\"> " ;
    s2 = s1 + s2 +s3 + s4 + s + "</text> \n" ;
    if (isOK)
    {
        outfile->Write (s2.c_str(), s2.Len() ) ;
    }
    isOK = outfile->IsOk ();
    wxASSERT_MSG(!wxSVG_DEBUG, "wxSVGFileDC::DrawText Call executed") ;

}


static inline double DegToRad(double deg) { return (deg * 3.14) / 180.0; }
//static inline double RadToDeg(double rad) { return (rad * 180.0) / 3.14; }
;

void wxSVGFileDC::DoDrawRotatedText(const wxString& text, wxCoord x, wxCoord y, double angle)
{
    wxString s1, s2, s3, s4, sf ;
    wxString s = text ;                           // as text is used in <>

    // calculate bounding box
    wxCoord w, h;
    wxCoord x0 = x ;
    wxCoord y0 = y ;
    wxCoord desc ;
    DoGetTextExtent(text, &w, &h, &desc);

    double rad = DegToRad(angle);

    // "upper left" and "upper right"
    CalcBoundingBox(x, y);
    CalcBoundingBox(x + w*cos(rad), y - h*sin(rad));

    // "bottom left" and "bottom right"
    x += (wxCoord)(h*sin(rad));
    y += (wxCoord)(h*cos(rad));
    CalcBoundingBox(x, y);
    CalcBoundingBox(x + h*sin(rad), y + h*cos(rad));

    // draw background first
    // just like DoDrwRectangle except we pass the text color to it and set the border to a 1 pixel wide text background
   
    wxASSERT_MSG(!wxSVG_DEBUG, "wxSVGFileDC::Draw Rotated Text Call plotting text background") ;

    if (m_backgroundMode == wxSOLID)
    {
        s1.Printf ( " <rect x=\"%d\" y=\"%d\" width=\"%d\" height=\"%d\"  ", x,y+desc-h, w, h);
        s1 = s1 + "style=\"fill:#" + wxColStr (m_textBackgroundColour) + "; " ;
        s1 = s1 + "stroke-width:1; stroke:#" + wxColStr (m_textBackgroundColour) + "; " ;
        s4.Printf ( "\" transform=\"rotate( %.2g %d %d )  \">", -angle, x0,y0 ) ;
        s1 = s1 + s4 + newline ;
        outfile->Write (s1.c_str(), s1.Len() ) ;
    }

    s1.Printf (" <text x=\"%d\" y=\"%d\" ",x,y );

    sf = m_font.GetFaceName () ;
    if (sf.Len () > 0)  s2 = "style=\"font-family:" + sf + "; ";
    else s2 = "style=\" " ;
    s3.Printf ("font-size:%dpt; fill:#", m_font.GetPointSize () );
    s3 = s3  + wxColStr (m_textForegroundColour) + "; stroke:#" + wxColStr (m_textForegroundColour) + "; " ;
    s4.Printf ( "stroke-width:0;\"  transform=\"rotate( %.2g %d %d )  \" >",  -angle, x0,y0 ) ;
    s2 = s1 + s2 + s3 + s4 + s + "</text> \n" ;
    if (isOK)
    {
        outfile->Write (s2.c_str(), s2.Len() ) ;
    }
    isOK = outfile->IsOk ();
    wxASSERT_MSG(!wxSVG_DEBUG, "wxSVGFileDC::DrawRotatedText Call executed") ;

}


wxSVGFileDC::~wxSVGFileDC()

{
    wxString s = "</g> \n</svg> \n" ;
    outfile->Write (s.c_str(), s.Len() ) ;
    //outfile -> Close();
    isOK = outfile->IsOk ();
    delete outfile ;
}

void wxSVGFileDC::SetBackground( const wxBrush &brush )
{

 
    m_backgroundBrush = brush;

     return;
     }
void wxSVGFileDC::SetBackgroundMode( int mode )
{
    m_backgroundMode = mode;

    return;
    }
    
void wxSVGFileDC::SetBrush(const wxBrush& brush)

{
    if (brush == wxNullBrush)
    {
        m_brush = m_prevbrush ;
        m_prevbrush = m_oldbrush;
        m_oldbrush = *wxWHITE_BRUSH ;
    }
    else
    {
        m_oldbrush = m_prevbrush ;
        m_prevbrush = m_brush ;
        m_brush = brush ;
    }

}


void wxSVGFileDC::SetPen(const wxPen& pen)
{
    // pens have width, color, ends, joins currently implemented
    // dashes, stipple   not implemented
    if (pen == wxNullPen)
    {
        m_pen = m_prevpen;
        m_prevpen = m_oldpen ;
        m_oldpen = *wxBLACK_PEN ;
    }
    else
    {
        m_oldpen = m_prevpen ;
        m_prevpen = m_pen ;
        m_pen = pen ;
    }
    int w = m_pen.GetWidth ();
    wxColour c = m_pen.GetColour () ;
    
    wxString s, s1, s2, s3, s4, s5, sWarn;
    s1 = "</g>\n<g style=\"fill:#" + wxColStr (c) + "; stroke:#" + wxColStr (c) + "; " ;
    switch ( m_pen.GetCap () )
        {
    	case  wxCAP_PROJECTING :
    		s2 = "stroke-linecap:square; " ; 
    		break ;
    	case  wxCAP_BUTT :
    		s2 = "stroke-linecap:butt; " ;
    		break ;
    	case 	wxCAP_ROUND :
    	default :
		s2 = "stroke-linecap:round; " ;
        };
    switch ( m_pen.GetJoin () )
        {
    	case  wxJOIN_BEVEL :  
    		s3 = "stroke-linejoin:bevel; " ; 
    		break ;
    	case  wxJOIN_MITER :
    		s3 = "stroke-linejoin:miter; " ;
    		break ;
    	case 	wxJOIN_ROUND :
    	default :
		s3 = "stroke-linejoin:round; " ;
        };
    
    switch ( m_pen.GetStyle () )
        {
    	case  wxSOLID :
    	 		s4 = "fill-opacity:1.0; stroke-opacity:1.0; " ;
    	 		break ;
    	case  wxTRANSPARENT : 
    			s4 = "fill-opacity:0.0; stroke-opacity:0.0; " ;
    			break ;
    	default :
    	wxASSERT_MSG(FALSE, "wxSVGFileDC::SetPen Call called to set a Style which is not available") ;
    	sWarn = "<!--- wxSVGFileDC::SetPen Call called to set a Style which is not available --> \n" ;
        }
    
    s5.Printf (   "stroke-width:%d\">",  w );
    	
    s = s1 + s2 + s3 + s4 + s5 + newline + sWarn;
    outfile->Write (s.c_str(), s.Len() ) ;
    isOK = outfile->IsOk ();

    wxASSERT_MSG(!wxSVG_DEBUG, "wxSVGFileDC::SetPen Call executed") ;
}


void wxSVGFileDC::SetFont(const wxFont& font)

{
    if (font == wxNullFont)
    {
        m_font = m_prevfont ;
        m_prevfont = m_oldfont;
        m_oldfont = *wxNORMAL_FONT ;
    }
    else
    {
        m_oldfont = m_prevfont ;
        m_prevfont = m_font ;
        m_font = font ;
    }

    wxASSERT_MSG(!wxSVG_DEBUG, "wxSVGFileDC::SetFont Call executed") ;
}

void wxSVGFileDC::DoDrawRectangle(wxCoord x, wxCoord y, wxCoord width, wxCoord height)
{
    DoDrawRoundedRectangle(x, y, width, height, 0)  ;
}


                                                 
void wxSVGFileDC::DoDrawRoundedRectangle(wxCoord x, wxCoord y, wxCoord width, wxCoord height, double radius )

{

    wxString s, s1, s2 ;
    
    s.Printf ( " <rect x=\"%d\" y=\"%d\" width=\"%d\" height=\"%d\" rx=\"%.2g\" ", x,y, width, height, radius);
    s1 =  "style=\"" ;
    s2 = wxBrushString ( m_brush.GetColour (), m_brush.GetStyle () );
    		
    s = s + s1 + s2 + " \" /> " + newline ;
    outfile->Write (s.c_str(), s.Len() ) ;
    isOK = outfile->IsOk ();

    wxASSERT_MSG(!wxSVG_DEBUG, "wxSVGFileDC::DoDrawRoundedRectangle Call executed") ;
    CalcBoundingBox(x, y) ;
    CalcBoundingBox(x + width, y + height) ;

}


void wxSVGFileDC::DoGetTextExtent(const wxString& string, wxCoord *w, wxCoord *h, wxCoord *descent , wxCoord *externalLeading , wxFont *font) const                                           

{
    wxScreenDC sDC ;
    sDC.SetFont (m_font);
    if ( font != NULL ) sDC.SetFont ( *font );
    sDC.GetTextExtent(string, w,  h, descent, externalLeading );

    wxASSERT_MSG(!wxSVG_DEBUG, "wxSVGFileDC::GetTextExtent Call executed") ;
}


void wxSVGFileDC::DoDrawEllipse (wxCoord x, wxCoord y, wxCoord width, wxCoord height)

{
    wxColour c = m_brush.GetColour () ;

    int rh = height /2 ;
    int rw = width  /2 ;

    wxString s, s1, s2 ;
    s.Printf ( "<ellipse cx=\"%d\" cy=\"%d\" rx=\"%d\" ry=\"%d\" ", x+rw,y+rh, rw, rh );
    s1 = "style=\"" ;
    s2 = wxBrushString ( m_brush.GetColour (), m_brush.GetStyle () );
    		
    s = s + s1 + s2 + " \" /> " + newline ;

    outfile->Write (s.c_str(), s.Len() ) ;
    isOK = outfile->IsOk ();

    wxASSERT_MSG(!wxSVG_DEBUG, "wxSVGFileDC::DoDrawEllipse Call executed") ;
    CalcBoundingBox(x, y) ;
    CalcBoundingBox(x + width, y + height) ;
}


wxCoord wxSVGFileDC::GetCharHeight() const

{
    wxScreenDC sDC ;
    sDC.SetFont (m_font);

    wxASSERT_MSG(!wxSVG_DEBUG, "wxSVGFileDC::GetCharHeight Call executing") ;
    return ( sDC.GetCharHeight() );

}


wxCoord wxSVGFileDC::GetCharWidth() const
{
    wxScreenDC sDC ;
    sDC.SetFont (m_font);

    wxASSERT_MSG(!wxSVG_DEBUG, "wxSVGFileDC::GetCharWidth Call executing") ;
    return ( sDC.GetCharWidth()  );

}




void wxSVGFileDC::DoDrawLines(int n, wxPoint points[], wxCoord xoffset , wxCoord yoffset )
{
    for ( int i = 1; i < n ; i++ )
    {
        DoDrawLine ( points [i-1].x + xoffset, points [i-1].y + yoffset,
            points [ i ].x + xoffset, points [ i ].y + yoffset ) ;
    }
}


void wxSVGFileDC::DoDrawPolygon(int n, wxPoint points[], wxCoord xoffset, wxCoord yoffset,int fillStyle)
{
    wxColour c = m_brush.GetColour () ;
    
    wxString s, s2 ;
    s = "<polygon style=\"" + wxBrushString ( m_brush.GetColour (), m_brush.GetStyle () );
    if ( fillStyle == wxODDEVEN_RULE )
        s = s + "; fill-rule:evenodd; ";
    else
        s = s + "; fill-rule:nonzero; ";
 
    
    s = s  + "\" \npoints=\"" ;

    for (int i = 0; i < n;  i++)
    {
        s2.Printf ( "%d,%d", points [i].x+xoffset, points[i].y+yoffset);
        s = s + s2 + newline ;
        CalcBoundingBox ( points [i].x+xoffset, points[i].y+yoffset);
    }
    s = s + "\" /> " ;
    s = s + newline ;
    outfile->Write (s.c_str(), s.Len() ) ;
    isOK = outfile->IsOk ();

    wxASSERT_MSG(!wxSVG_DEBUG, "wxSVGFileDC::DoDrawPolygon Call executed") ;
}


void wxSVGFileDC::DoDrawArc(wxCoord x1, wxCoord y1, wxCoord x2, wxCoord y2, wxCoord xc, wxCoord yc)
{
    /* Draws an arc of a circle, centred on (xc, yc), with starting point
    (x1, y1) and ending at (x2, y2). The current pen is used for the outline
    and the current brush for filling the shape.

    The arc is drawn in an anticlockwise direction from the start point to
    the end point.

    Might be better described as Pie drawing */

    wxString s, s2 ;

    // we need the radius of the circle which has two estimates
    double r1 = sqrt ( double( (x1-xc)*(x1-xc) ) + double( (y1-yc)*(y1-yc) ) );
    double r2 = sqrt ( double( (x2-xc)*(x2-xc) ) + double( (y2-yc)*(y2-yc) ) );

    wxASSERT_MSG( (fabs ( r2-r1 ) <= 3), "wxSVGFileDC::DoDrawArc Error in getting radii of circle") ;
    if ( fabs ( r2-r1 ) > 3 )                     //pixels
    {
        s = "<!--- wxSVGFileDC::DoDrawArc Error in getting radii of circle --> \n" ;
        outfile->Write (s.c_str(), s.Len() ) ;
    }

    double theta1 = atan2( double(yc-y1), double(x1-xc) );
    if ( theta1 < 0 ) theta1 = theta1 + 3.14 * 2;
    double theta2 = atan2( double(yc-y2), double(x2-xc));
    if ( theta2 < 0 ) theta2 = theta2 + 3.14 * 2;
    if ( theta2 < theta1 ) theta2 = theta2 + 3.14 *2 ;

    int fArc  ;                                   // flag for large or small arc 0 means less than 180 degrees
    if (  fabs(theta2 - theta1) > 3.14 ) fArc = 1; else fArc = 0 ;

    int fSweep = 0 ;                              // flag for sweep always 0

    s.Printf ( "<path d=\"M%d %d A%.3g %.3g 0.0 %d %d %d %d L%d %d z \" ", x1,y1, r1, r2, fArc, fSweep, x2,y2, xc, yc );
    // the z means close the path and fill

   
    s2 =  "style=\"" ;
    s2 =  s2 + wxBrushString ( m_brush.GetColour (), m_brush.GetStyle () );
    		
    s = s + s2 + " \" /> " + newline ;


    if (isOK)
    {
        outfile->Write (s.c_str(), s.Len() ) ;
    }
    isOK = outfile->IsOk ();

    wxASSERT_MSG(!wxSVG_DEBUG, "wxSVGFileDC::DoDrawArc Call executed") ;
}


void wxSVGFileDC::DoDrawEllipticArc(wxCoord x,wxCoord y,wxCoord w,wxCoord h,double sa,double ea)
{
    /*
    Draws an arc of an ellipse. The current pen is used for drawing the arc
    and the current brush is used for drawing the pie. This function is
    currently only available for X window and PostScript device contexts.

    x and y specify the x and y coordinates of the upper-left corner of the
    rectangle that contains the ellipse.

    width and height specify the width and height of the rectangle that
    contains the ellipse.

    start and end specify the start and end of the arc relative to the
    three-o'clock position from the center of the rectangle. Angles are
    specified in degrees (360 is a complete circle). Positive values mean
    counter-clockwise motion. If start is equal to end, a complete ellipse
    will be drawn. */
// Bug this draw the full pie segment, unlike MSW
    wxString s, s2 ;

    double rx = w / 2 ;
    double ry = h / 2 ;

    double xc = x + rx ;
    double yc = y + ry ;

    double xs, ys, xe, ye ;
    xs = xc + rx * cos (DegToRad(sa)) ;
    xe = xc + rx * cos (DegToRad(ea)) ;
    ys = yc + ry * sin (DegToRad(sa)) ;
    ye = yc + ry * sin (DegToRad(ea)) ;

    ///now same as circle arc...

    double theta1 = atan2(yc-ys,xs-xc);
    if ( theta1 < 0 ) theta1 = theta1 + 3.14 * 2;
    double theta2 = atan2(yc-ye, xe-xc);
    if ( theta2 < 0 ) theta2 = theta2 + 3.14 * 2;
    if ( theta2 < theta1 ) theta2 = theta2 + 3.14 *2 ;

    int fArc  ;                                   // flag for large or small arc 0 means less than 180 degrees
    if ( fabs( double(theta2 - theta1)) > 3.14) fArc = 1; else fArc = 0 ;

    int fSweep = 0 ;                              // flag for sweep always 0

    s.Printf ( "<path d=\"M%.3g %.3g A%.3g %.3g 0.0 %d %d  %.3g %.3g  \" ",
                            xs,  ys,  rx,   ry,   fArc,fSweep,xe,  ye  );

    s2 = "style=\"" +wxBrushString ( m_brush.GetColour (), m_brush.GetStyle () );
    		
    s = s + s2 + " \" /> " + newline ;

    if (isOK)
    {
        outfile->Write (s.c_str(), s.Len() ) ;
    }
    isOK = outfile->IsOk ();

    wxASSERT_MSG(!wxSVG_DEBUG, "wxSVGFileDC::DoDrawEllipticArc Call executed") ;
}


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#if wxUSE_SPLINES

class wxSpline: public wxObject
{
    public:
        int type;
        wxList *points;

        wxSpline(wxList *list);
        void DeletePoints();

        // Doesn't delete points
        ~wxSpline();
};

static void wx_draw_open_spline(wxDC *dc, wxSpline *spline);

static void wx_quadratic_spline(double a1, double b1, double a2, double b2,
double a3, double b3, double a4, double b4);
static void wx_clear_stack();
static int wx_spline_pop(double *x1, double *y1, double *x2, double *y2, double *x3,
double *y3, double *x4, double *y4);
static void wx_spline_push(double x1, double y1, double x2, double y2, double x3, double y3,
double x4, double y4);
static bool wx_spline_add_point(double x, double y);
static void wx_spline_draw_point_array(wxDC *dc);

void wxSVGFileDC::DoDrawSpline(wxList *list)
{
    wxSpline spline(list);

    wx_draw_open_spline(this, &spline);
    wxASSERT_MSG(!wxSVG_DEBUG, "wxSVGFileDC::DoDrawSpline Call executed") ;
}


static wxList wx_spline_point_list;

static void wx_draw_open_spline(wxDC *dc, wxSpline *spline)
{
    wxPoint *p;
    double           cx1, cy1, cx2, cy2, cx3, cy3, cx4, cy4;
    double           x1, y1, x2, y2;

    wxNode *node = spline->points->First();
    p = (wxPoint *)node->Data();

    x1 = p->x;
    y1 = p->y;

    node = node->Next();
    p = (wxPoint *)node->Data();

    x2 = p->x;
    y2 = p->y;
    cx1 = (double)((x1 + x2) / 2);
    cy1 = (double)((y1 + y2) / 2);
    cx2 = (double)((cx1 + x2) / 2);
    cy2 = (double)((cy1 + y2) / 2);

    wx_spline_add_point(x1, y1);

    while ((node = node->Next()) != NULL)
    {
        p = (wxPoint *)node->Data();
        x1 = x2;
        y1 = y2;
        x2 = p->x;
        y2 = p->y;
        cx4 = (double)(x1 + x2) / 2;
        cy4 = (double)(y1 + y2) / 2;
        cx3 = (double)(x1 + cx4) / 2;
        cy3 = (double)(y1 + cy4) / 2;

        wx_quadratic_spline(cx1, cy1, cx2, cy2, cx3, cy3, cx4, cy4);

        cx1 = cx4;
        cy1 = cy4;
        cx2 = (double)(cx1 + x2) / 2;
        cy2 = (double)(cy1 + y2) / 2;
    }

    wx_spline_add_point((double)wx_round(cx1), (double)wx_round(cy1));
    wx_spline_add_point(x2, y2);

    wx_spline_draw_point_array(dc);

}


/********************* CURVES FOR SPLINES *****************************

  The following spline drawing routine is from

    "An Algorithm for High-Speed Curve Generation"
    by George Merrill Chaikin,
    Computer Graphics and Image Processing, 3, Academic Press,
    1974, 346-349.

      and

"On Chaikin's Algorithm" by R. F. Riesenfeld,
Computer Graphics and Image Processing, 4, Academic Press,
1975, 304-310.

***********************************************************************/

#define     half(z1, z2)    ((z1+z2)/2.0)
#define     THRESHOLD   5

/* iterative version */

static void wx_quadratic_spline(double a1, double b1, double a2, double b2, double a3, double b3, double a4,
double b4)
{
    register double  xmid, ymid;
    double           x1, y1, x2, y2, x3, y3, x4, y4;

    wx_clear_stack();
    wx_spline_push(a1, b1, a2, b2, a3, b3, a4, b4);

    while (wx_spline_pop(&x1, &y1, &x2, &y2, &x3, &y3, &x4, &y4))
    {
        xmid = (double)half(x2, x3);
        ymid = (double)half(y2, y3);
        if (fabs(x1 - xmid) < THRESHOLD && fabs(y1 - ymid) < THRESHOLD &&
            fabs(xmid - x4) < THRESHOLD && fabs(ymid - y4) < THRESHOLD)
        {
            wx_spline_add_point((double)wx_round(x1), (double)wx_round(y1));
            wx_spline_add_point((double)wx_round(xmid), (double)wx_round(ymid));
        }
        else
        {
            wx_spline_push(xmid, ymid, (double)half(xmid, x3), (double)half(ymid, y3),
                (double)half(x3, x4), (double)half(y3, y4), x4, y4);
            wx_spline_push(x1, y1, (double)half(x1, x2), (double)half(y1, y2),
                (double)half(x2, xmid), (double)half(y2, ymid), xmid, ymid);
        }
    }
}


/* utilities used by spline drawing routines */

typedef struct wx_spline_stack_struct
{
    double           x1, y1, x2, y2, x3, y3, x4, y4;
}


Stack;

#define         SPLINE_STACK_DEPTH             20
static Stack    wx_spline_stack[SPLINE_STACK_DEPTH];
static Stack   *wx_stack_top;
static int      wx_stack_count;

static void wx_clear_stack()
{
    wx_stack_top = wx_spline_stack;
    wx_stack_count = 0;
}


static void wx_spline_push(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4)
{
    wx_stack_top->x1 = x1;
    wx_stack_top->y1 = y1;
    wx_stack_top->x2 = x2;
    wx_stack_top->y2 = y2;
    wx_stack_top->x3 = x3;
    wx_stack_top->y3 = y3;
    wx_stack_top->x4 = x4;
    wx_stack_top->y4 = y4;
    wx_stack_top++;
    wx_stack_count++;
}


static int wx_spline_pop(double *x1, double *y1, double *x2, double *y2,
double *x3, double *y3, double *x4, double *y4)
{
    if (wx_stack_count == 0)
        return (0);
    wx_stack_top--;
    wx_stack_count--;
    *x1 = wx_stack_top->x1;
    *y1 = wx_stack_top->y1;
    *x2 = wx_stack_top->x2;
    *y2 = wx_stack_top->y2;
    *x3 = wx_stack_top->x3;
    *y3 = wx_stack_top->y3;
    *x4 = wx_stack_top->x4;
    *y4 = wx_stack_top->y4;
    return (1);
}


static bool wx_spline_add_point(double x, double y)
{
    wxPoint *point = new wxPoint;
    point->x = (int) x;
    point->y = (int) y;
    wx_spline_point_list.Append((wxObject*)point);
    return TRUE;
}


static void wx_spline_draw_point_array(wxDC *dc)
{
    dc->DrawLines(&wx_spline_point_list, 0, 0);
    wxNode *node = wx_spline_point_list.First();
    while (node)
    {
        wxPoint *point = (wxPoint *)node->Data();
        delete point;
        delete node;
        node = wx_spline_point_list.First();
    }
}


wxSpline::wxSpline(wxList *list)
{
    points = list;
}


wxSpline::~wxSpline()
{
}


void wxSpline::DeletePoints()
{
    for(wxNode *node = points->First(); node; node = points->First())
    {
        wxPoint *point = (wxPoint *)node->Data();
        delete point;
        delete node;
    }
    delete points;
}
#endif                                            // wxUSE_SPLINES
